 // Mobile menu toggle functionality
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.getElementById('mobileMenuToggle');
            const mobileNav = document.getElementById('mobileNav');

            if (mobileMenuToggle && mobileNav) {
                mobileMenuToggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    mobileMenuToggle.classList.toggle('active');
                    mobileNav.classList.toggle('active');
                });

                // Close mobile menu when clicking on navigation links
                const mobileNavItems = document.querySelectorAll('.mobile-nav-item, .mobile-contact-btn');
                mobileNavItems.forEach(item => {
                    item.addEventListener('click', function() {
                        mobileMenuToggle.classList.remove('active');
                        mobileNav.classList.remove('active');
                    });
                });

                // Close mobile menu when clicking outside
                document.addEventListener('click', function(event) {
                    if (!event.target.closest('.header-container')) {
                        mobileMenuToggle.classList.remove('active');
                        mobileNav.classList.remove('active');
                    }
                });
            }
        });

        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth'
                    });
                }
            });
        });

        // Add click handlers for Calendly (placeholder)
        document.querySelectorAll('a[href="#calendly"]').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                alert('Hier würde das Calendly-Formular geöffnet werden.');
            });
        });
        function toggleFAQ(element) {
    const faqItem = element.parentElement;
    const isActive = faqItem.classList.contains('active');
    
    // Alle anderen FAQ Items schließen
    document.querySelectorAll('.faq-item').forEach(item => {
        item.classList.remove('active');
    });
    
    // Aktuelles Item öffnen/schließen
    if (!isActive) {
        faqItem.classList.add('active');
    }
}
        // Footer link handlers (placeholder)
document.querySelectorAll('.footer-icon, .footer-link').forEach(link => {
    link.addEventListener('click', function(e) {
        e.preventDefault();
        const href = this.getAttribute('href');
        if (href === '#email') {
            window.location.href = 'mailto:gideon@executive-va.com';
        } else if (href === '#whatsapp') {
            window.open('https://wa.me/deine-nummer', '_blank');
        } else if (href === '#telegram') {
            window.open('https://t.me/dein-telegram', '_blank');
        } else if (href === '#linkedin') {
            window.open('https://linkedin.com/in/gideon-neder', '_blank');
        } else if (href === '#calendar') {
            alert('Hier würde das Calendly-Formular geöffnet werden.');
        } else if (href === '#impressum') {
            window.location.href = 'impressum.html';
        } else if (href === '#datenschutz') {
            window.location.href = 'datenschutz.html';
        }
    });
});